<?php
defined('_VALID') or die('Restricted Access!');

Auth::checkAdmin();

if ( !function_exists('curl_init') ) {
	$errors[] = 'You need php-curl installed to use this module. See: <a href="http://www.php.net/curl">http://www.php.net/curl</a>!';
}

require $config['BASE_DIR']. '/include/config.grabber.php';
require $config['BASE_DIR']. '/classes/curl.class.php';
require $config['BASE_DIR']. '/include/function_video.php';

$categories = get_categories();
$video      = array('site' => '', 'title' => '', 'category' => '', 'tags' => '',
                    'username' => 'anonymous', 'url' => '', 'id' => '', 'size' => '', 'type' => 'public');
if ( isset($_POST['grab_video']) ) {
    $url        = trim($_POST['url']);
    $site       = trim($_POST['site']);
    
    if ( $url == '' ) {
        $errors[] = 'Please enter video url!';
    }
    
    if ( !$errors ) {
        require $config['BASE_DIR']. '/classes/grabers/' .$site. '.class.php';
        $class              = 'VGrab_' .$site;
        $graber             = new $class;
        $graber->getPage($url);
        $video['site']      = $site;
        $video['title']     = $graber->getVideoTitle();
        $video['tags']      = $graber->getVideoTags();
        $video['category']  = $graber->getVideoCategory();
        foreach ( $categories as $category ) {
            if ( $category['name']. 's' == $video['category'] || $category['name'] == $video['category'] ) {
                $video['category'] = $category['name'];
                break;
            }
        }

        $video['id']        = $graber->getVideoId();
        $video['url']       = $graber->getVideoUrl();
        if ( $video['url'] ) {
            $curl           = new VCurl();
            $video['size']  = $curl->getRemoteSize($video['url']);
        }
        
        if ( !$video['url'] ) {
            $errors[]            = 'Failed to get video url! Are you sure the url is correct?';
        }
    }
}

if ( isset($_POST['save_video']) ) {
    $v_site_id  = trim($_POST['video_id']);
    $title      = trim($_POST['title']);
    $category   = intval(trim($_POST['category']));
    $tags       = trim($_POST['tags']);
    $url        = trim($_POST['url']);
    $username   = trim($_POST['username']);
    $type       = ( isset($_POST['type']) && $_POST['type'] == 'private' ) ? 'private' : 'public';
    
    if ( $username == '' ) {
        $errors[]                = 'Please enter a username!';
    } else {
        $sql        = "SELECT UID FROM signup WHERE username = '" .mysql_real_escape_string($username). "' LIMIT 1";
        $rs         = $conn->execute($sql);
        if ( $conn->Affected_Rows() == 1 ) {
            $uid                = intval($rs->fields['UID']);
            $video['username']  = $username;
        } else {
            $errors[]    = 'Username: ' .htmlspecialchars($username, ENT_QUOTES, 'UTF-8'). 'does not exist!';
        }
    }
    
    if ( $title == '' ) {
        $errors[]                = 'Please enter a video title!';
    } else {
        $video['title']     = $title;
    }
    
    if ( $category === 0 ) {
        $errors[]                = 'Please select a video category!';
    } else {
        $video['category']  = $category;
    }
    
    if ( $tags == '' ) {
        $errors[]                = 'Please enter video tags!';
    } else {
        $video['tags']      = $tags;
    }
    
    if ( $url == '' ) {
        $errors[]                = 'Please enter a url for the flash video to be downloaded!';
    } else {
        $video['url']       = $url;
    }
    
    $video['size']          = trim($_POST['size']);
    $video['site']          = trim($_POST['site']);
    $video['type']          = $type;
    
    if ( !$errors ) {
        $sql        = "INSERT INTO video (UID, title, channel, vkey, keyword, type, addtime, adddate)
                       VALUES (" .$uid. ", '" .mysql_real_escape_string($title). "', '" .$category. "',
                               '" .mt_rand(). "', '" .mysql_real_escape_string($tags). "',
                               '" .$type. "', '" .time(). "', '" .date('Y-m-d'). "')";
        $conn->execute($sql);
        $vid            = mysql_insert_id();    
        $curl           = new VCurl();
        $dst            = $config['BASE_DIR']. '/media/videos/flv/' .$vid. '.flv';
        if ( !$curl->saveToFile($url, $dst) ) {
            $sql        = "DELETE FROM video WHERE VID = " .$vid. " LIMIT 1";
            $conn->execute($sql);
            $errors[]        = 'Failed to download video file!';
        } else {
            extract_video_thumbs($dst, $vid);
            $duration   = get_video_duration($dst, $vid);
            $size       = filesize($dst);
            $vkey       = substr(md5($vid),11,20);
            $vdoname    = $vid. '.flv';
            $flvdoname  = $vid. '.flv';
            $sql        = "UPDATE video SET duration = '" .mysql_real_escape_string($duration). "', vkey = '" .$vkey. "',
                                            vdoname = '" .mysql_real_escape_string($vdoname). "', flvdoname = '" .mysql_real_escape_string($flvdoname). "',
                                            space = " .$size. ", active = '1'
                           WHERE VID = " .intval($vid). " LIMIT 1";
            $conn->execute($sql);
            $sql        = "UPDATE channel SET total_videos = total_videos+1 WHERE CHID = " .$category. " LIMIT 1";
            $conn->execute($sql);
            $sql        = "INSERT INTO grab (site, id)
                           VALUES ('" .mysql_real_escape_string($video['site']). "', '" .mysql_real_escape_string($v_site_id). "')";
            $conn->execute($sql);
            $messages[] = 'Video was successfully added!';                                                                                            
        }
    }
}

$smarty->assign('video', $video);
$smarty->assign('sites', $sites);
$smarty->assign('categories', get_categories());
?>
